/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.extensions;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.extensions.IThemeableEditor;
import com.aptana.editor.common.extensions.LineBackgroundPainter;
import com.aptana.theme.IThemeManager;
import com.aptana.theme.ThemePlugin;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.osgi.service.prefs.BackingStoreException;

public class ThemeableEditorExtension {
    private Composite fParent;
    private LineNumberRulerColumn fLineColumn;
    private LineBackgroundPainter fFullLineBackgroundPainter;
    private WeakReference<IThemeableEditor> fEditor;

    public ThemeableEditorExtension(IThemeableEditor editor) {
        this.fEditor = new WeakReference<IThemeableEditor>(editor);
    }

    public void overrideThemeColors() {
        IThemeableEditor editor = (IThemeableEditor)this.fEditor.get();
        if (editor != null) {
            ThemePlugin.getDefault().getControlThemerFactory().apply((ITextViewer)editor.getISourceViewer());
        }
        this.setCharacterPairColor(this.getThemeManager().getCurrentTheme().getCharacterPairColor());
        this.overrideRulerColors();
    }

    public void initializeLineNumberRulerColumn(LineNumberRulerColumn rulerColumn) {
        this.fLineColumn = rulerColumn;
    }

    public void setParent(Composite parent) {
        this.fParent = parent;
    }

    public void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        if (event.getProperty().equals("THEME_CHANGED")) {
            IThemeableEditor editor = (IThemeableEditor)this.fEditor.get();
            this.overrideThemeColors();
            if (editor != null) {
                editor.getISourceViewer().invalidateTextPresentation();
            }
        } else if (event.getProperty().equals("currentLine")) {
            Object newValue = event.getNewValue();
            if (newValue instanceof Boolean) {
                boolean on = (Boolean)newValue;
                this.fFullLineBackgroundPainter.setHighlightLineEnabled(on);
            }
        } else if (event.getProperty().equals("AbstractTextEditor.Color.SelectionBackground.SystemDefault")) {
            this.overrideRulerColors();
        }
    }

    public void createBackgroundPainter(ISourceViewer viewer) {
        if (this.fFullLineBackgroundPainter == null && viewer instanceof ITextViewerExtension2) {
            boolean lineHighlight = Platform.getPreferencesService().getBoolean("org.eclipse.ui.editors", "currentLine", true, null);
            this.fFullLineBackgroundPainter = new LineBackgroundPainter(viewer);
            this.fFullLineBackgroundPainter.setHighlightLineEnabled(lineHighlight);
            ITextViewerExtension2 extension = (ITextViewerExtension2)viewer;
            extension.addPainter((IPainter)this.fFullLineBackgroundPainter);
        }
    }

    public void dispose() {
        this.fLineColumn = null;
        if (this.fEditor != null) {
            this.fEditor.clear();
            this.fEditor = null;
        }
        this.fParent = null;
        if (this.fFullLineBackgroundPainter != null) {
            this.fFullLineBackgroundPainter.deactivate(true);
            this.fFullLineBackgroundPainter.dispose();
            this.fFullLineBackgroundPainter = null;
        }
    }

    protected IThemeManager getThemeManager() {
        return ThemePlugin.getDefault().getThemeManager();
    }

    private void overrideRulerColors() {
        IThemeableEditor editor = (IThemeableEditor)this.fEditor.get();
        Color bg = null;
        if (editor != null) {
            StyledText text;
            ISourceViewer sv = editor.getISourceViewer();
            if (sv != null && (text = sv.getTextWidget()) != null) {
                bg = text.getBackground();
                bg = ThemePlugin.getDefault().getColorManager().getColor(bg.getRGB());
            }
            CompositeRuler ruler = (CompositeRuler)editor.getIVerticalRuler();
            Iterator iter = ruler.getDecoratorIterator();
            while (iter.hasNext()) {
                IVerticalRulerColumn column = (IVerticalRulerColumn)iter.next();
                column.getControl().setBackground(bg);
            }
        }
        if (this.fLineColumn != null) {
            this.fLineColumn.setBackground(bg);
        }
    }

    private void setCharacterPairColor(RGB rgb) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.editor.common");
        prefs.put("com.aptana.editor.common.characterPairColor", MessageFormat.format("{0},{1},{2}", rgb.red, rgb.green, rgb.blue));
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }
}

